/*******************************************************************
*
*  DESCRIPTION: Simulator::registerNewAtomics()
*
*  AUTHOR: Shagun Goel 
*
**
*******************************************************************/

#include "modeladm.h" 
#include "mainsimu.h"
#include "counter.h"	 // class counter
#include "auditor.h" // class auditor
#include "cashier.h"       // class cashier
#include "order.h"     // class orderingstation
#include "cpu.h"         // class CPU
#include "transduc.h"    // class Transducer
#include "trafico.h"     // class Trafico


void MainSimulator::registerNewAtomics()
{
SingleModelAdm::Instance().registerAtomic( NewAtomicFunction<counter>() , "counter" ) ;
SingleModelAdm::Instance().registerAtomic( NewAtomicFunction<auditor>() , "auditor" ) ;
SingleModelAdm::Instance().registerAtomic( NewAtomicFunction<cashier>() , "cashier" ) ;
SingleModelAdm::Instance().registerAtomic( NewAtomicFunction<orderingstation>() , "orderingstation" ) ;
SingleModelAdm::Instance().registerAtomic( NewAtomicFunction<CPU>() , "CPU" ) ;
SingleModelAdm::Instance().registerAtomic( NewAtomicFunction<Transducer>() , "Transducer" ) ;
SingleModelAdm::Instance().registerAtomic( NewAtomicFunction<Trafico>() , "Trafico" ) ;
}
